/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h14199.api.Interval;
import org.h14199.api.IntervalQualifier;
import org.h14199.message.DbException;
import org.h14199.util.DateTimeUtils;
import org.h14199.util.IntervalUtils;
import org.h14199.value.CompareMode;
import org.h14199.value.TypeInfo;
import org.h14199.value.Value;

public class ValueInterval
extends Value {
    public static final int DEFAULT_PRECISION = 2;
    public static final int MAXIMUM_PRECISION = 18;
    static final int DEFAULT_SCALE = 6;
    public static final int MAXIMUM_SCALE = 9;
    private final int valueType;
    private TypeInfo type;
    private final boolean negative;
    private final long leading;
    private final long remaining;

    public static ValueInterval from(IntervalQualifier intervalQualifier, boolean bl, long l, long l2) {
        bl = IntervalUtils.validateInterval(intervalQualifier, bl, l, l2);
        return (ValueInterval)Value.cache(new ValueInterval(intervalQualifier.ordinal() + 26, bl, l, l2));
    }

    public static int getDisplaySize(int n, int n2, int n3) {
        switch (n) {
            case 26: 
            case 29: {
                return 17 + n2;
            }
            case 27: {
                return 18 + n2;
            }
            case 28: {
                return 16 + n2;
            }
            case 30: {
                return 19 + n2;
            }
            case 31: {
                return n3 > 0 ? 20 + n2 + n3 : 19 + n2;
            }
            case 32: {
                return 29 + n2;
            }
            case 33: {
                return 27 + n2;
            }
            case 34: {
                return 32 + n2;
            }
            case 35: {
                return n3 > 0 ? 36 + n2 + n3 : 35 + n2;
            }
            case 36: {
                return 30 + n2;
            }
            case 37: {
                return n3 > 0 ? 34 + n2 + n3 : 33 + n2;
            }
            case 38: {
                return n3 > 0 ? 33 + n2 + n3 : 32 + n2;
            }
        }
        throw DbException.getUnsupportedException(Integer.toString(n));
    }

    private ValueInterval(int n, boolean bl, long l, long l2) {
        this.valueType = n;
        this.negative = bl;
        this.leading = l;
        this.remaining = l2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return IntervalUtils.appendInterval(stringBuilder, this.getQualifier(), this.negative, this.leading, this.remaining);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            int n = 0;
            for (long i = this.leading; i > 0L; i /= 10L) {
                ++n;
            }
            if (n == 0) {
                n = 1;
            }
            this.type = typeInfo = new TypeInfo(this.valueType, n, 0, ValueInterval.getDisplaySize(this.valueType, 18, 9), null);
        }
        return typeInfo;
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    @Override
    public int getMemory() {
        return 48;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 9) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        IntervalQualifier intervalQualifier = this.getQualifier();
        if (!intervalQualifier.hasSeconds()) {
            return this;
        }
        long l = DateTimeUtils.convertScale(this.remaining, n);
        if (l == this.remaining) {
            return this;
        }
        long l2 = this.leading;
        switch (this.valueType) {
            case 31: {
                if (l < 1000000000L) break;
                ++l2;
                l -= 1000000000L;
                break;
            }
            case 35: {
                if (l < 86400000000000L) break;
                ++l2;
                l -= 86400000000000L;
                break;
            }
            case 37: {
                if (l < 3600000000000L) break;
                ++l2;
                l -= 3600000000000L;
                break;
            }
            case 38: {
                if (l < 60000000000L) break;
                ++l2;
                l -= 60000000000L;
            }
        }
        return ValueInterval.from(intervalQualifier, this.negative, l2, l);
    }

    @Override
    public String getString() {
        return IntervalUtils.appendInterval(new StringBuilder(), this.getQualifier(), this.negative, this.leading, this.remaining).toString();
    }

    @Override
    public Object getObject() {
        return new Interval(this.getQualifier(), this.negative, this.leading, this.remaining);
    }

    public IntervalQualifier getQualifier() {
        return IntervalQualifier.valueOf(this.valueType - 26);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getRemaining() {
        return this.remaining;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(n, this.getString());
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + this.valueType;
        n = 31 * n + (this.negative ? 1231 : 1237);
        n = 31 * n + (int)(this.leading ^ this.leading >>> 32);
        n = 31 * n + (int)(this.remaining ^ this.remaining >>> 32);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueInterval)) {
            return false;
        }
        ValueInterval valueInterval = (ValueInterval)object;
        return this.valueType == valueInterval.valueType && this.negative == valueInterval.negative && this.leading == valueInterval.leading && this.remaining == valueInterval.remaining;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode) {
        ValueInterval valueInterval = (ValueInterval)value;
        if (this.negative != valueInterval.negative) {
            return this.negative ? -1 : 1;
        }
        int n = Long.compare(this.leading, valueInterval.leading);
        if (n == 0) {
            n = Long.compare(this.remaining, valueInterval.remaining);
        }
        return this.negative ? -n : n;
    }

    @Override
    public int getSignum() {
        return this.negative ? -1 : (this.leading == 0L && this.remaining == 0L ? 0 : 1);
    }

    @Override
    public Value add(Value value) {
        return IntervalUtils.intervalFromAbsolute(this.getQualifier(), IntervalUtils.intervalToAbsolute(this).add(IntervalUtils.intervalToAbsolute((ValueInterval)value)));
    }

    @Override
    public Value subtract(Value value) {
        return IntervalUtils.intervalFromAbsolute(this.getQualifier(), IntervalUtils.intervalToAbsolute(this).subtract(IntervalUtils.intervalToAbsolute((ValueInterval)value)));
    }

    @Override
    public Value negate() {
        if (this.leading == 0L && this.remaining == 0L) {
            return this;
        }
        return Value.cache(new ValueInterval(this.valueType, !this.negative, this.leading, this.remaining));
    }
}

